#Funkcija koja racuna Euler-ovu kriticnu silu
proc RacunajEulera {tipStapa} {
	#Unos modula elasticnosti
	puts -nonewline "Unesite E: ";
	flush stdout;
	gets stdin E;
	#Unos momenta inercije
	puts -nonewline "Unesite I: ";
	flush stdout;
	gets stdin I;
	#Unos povrsine poprecnog preseka
	puts -nonewline "Unesite A: ";
	flush stdout;
	gets stdin A;
	#Unos raspona
	puts -nonewline "Unesite L: ";
	flush stdout;
	gets stdin L;
	puts -nonewline "Unesite napon na granici proporcionalnosti Sigma,p: ";
	flush stdout;
	gets stdin Sp;
	#Proracun
	set PI [expr acos(-1)];
	flush stdout;
	puts -nonewline "\nRezultati analize za ";
	switch $tipStapa {
	"1" {set beta 1.0; puts "prostu gredu:"}
	"2" {set beta 0.7; puts "jednostrano ukljestenu gredu:"}
	"3" {set beta 0.5; puts "obostrano ukljestenu gredu:"}
	"4" {set beta 2.0; puts "konzolu:"}
	default {set beta 1.0; puts "prostu gredu:"}
	}
	#Kontrola da li su uneti brojevi
	if {[string is double -strict $E] &&
		[string is double -strict $I] && 
		[string is double -strict $A] &&
		[string is double -strict $L] && 
		[string is double -strict $Sp]} {
		#Kontrola unetih vrednosti
		if {$E > 0.0 && $I > 0.0 && $A > 0.0 && $L > 0.0 && $Sp > 0.0} {
			set brojDecimalaFormat "5f";
			set Pkr [expr pow($PI,2.0)*$E*$I/(pow(($beta*$L),2.0))];
			puts [format "Pkr = %.$brojDecimalaFormat" $Pkr];
			set Li [expr $beta*$L];
			puts [format "Li = %.$brojDecimalaFormat" $Li];
			set i [expr sqrt($I/$A)];
			puts [format "poluprecnik inercije i = %.$brojDecimalaFormat" $i];
			set vitkost [expr $Li/$i];
			puts [format "vitkost lambda = %.$brojDecimalaFormat" $vitkost];
			set vitkostP [expr $PI*sqrt($E/$Sp)];
			puts [format "vitkost na granici proporcionalnosti lambda,p = %.$brojDecimalaFormat" $vitkostP];
			set sigmaKr [expr pow($PI,2.0)*$E/pow($vitkost,2.0)];
			puts [format "kriticni napon sigmak = %.$brojDecimalaFormat" $sigmaKr];
		} else {
			puts "Greska!!!"
		}
	} else {
		puts "Greska!!!"
	}
}

#######################################################################
#ZA KONZOLNU VERZIJU APLIKACIJE
#Funkcija koja ispisuje meni
proc IspisiMeni {} {
	puts "------------------------------------";
	puts "------------------------------------";
	puts "EULER-ova kriticna sila";
	puts "Izlaz: 0";
	puts "Prosta greda: 1";
	puts "Jednostrano ukljestena greda: 2";
	puts "Obostrano ukljestena greda: 3";
	puts "Konzola: 4";
	puts "------------------------------------";	
}
#Petlja za meni
set unos 1;
while {$unos != 0} {
	IspisiMeni;
	puts -nonewline "Unesite opciju menija: ";
	flush stdout;
	gets stdin unos;
	switch $unos {
	"0" {break}
	"1" {RacunajEulera 1}
	"2" {RacunajEulera 2}
	"3" {RacunajEulera 3}
	"4" {RacunajEulera 4}
	default {continue}
	}
}
#######################################################################


